function [Yss, Error] = SSFun(varargin)

%Steady state for TGF
%Input is Ligand (molecules/cell)

K = varargin{1};
S = varargin{2};
U = varargin{3};

    y0 = [K.S2tot,0,K.S4tot,0,0,0,0,0,0,0];
    
    
    [T,Y] = ode15s(@ODEsFun,linspace(0,S.SS_Time,1000),y0,[],K,U);
    
    if abs((Y(end,S.Ind)-Y(round(.9*end),S.Ind))/Y(end,S.Ind))>.001
        Error = 1;
    else
        Error = 0;
    end

Yss = Y(end,:);


end
